/*****************************************************************************
*  LPC15xx SCT0 dithering demo program for LPCXpresso board
*
*  1. Use SCT0 timer to generate a 4 msec PWM output @ SCT0_OUT0
*  2. Duty cycle of the PWM signal starts with 25% (1msec ON, 3msec OFF)
*  3. SCT0_OUT0 is linked to P0_24 (green LED)
*  4. Pressing pushbutton S2 will change the LED brightness to 37.5% by
*     using the SCT dithering feature (average of 1.5msec ON, 2.5msec OFF)
*  5. Release pushbutton S2 will change the LED brightness back to 25%
*****************************************************************************/
#include "LPC15xx.h"

extern void SCT0_Init(void);

int main(void) 
{
  static uint8_t trg = 1;

    LPC_SYSCON->SYSAHBCLKCTRL0 |= (EN0_SWM | EN0_GPIO2);   // enable SWM and GPIO port 2 clocks
    LPC_SWM->PINASSIGN7        |= 0x0000FF00;              // ASSIGN7(15:8) = FF
//    LPC_SWM->PINASSIGN7        &= 0xFFFF18FF;              // P0_24 is SCT0_OUT0, ASSIGN7(15:8)
    LPC_SWM->PINASSIGN7        &= 0xFFFF07FF;              // P0_7 is SCT0_OUT0, ASSIGN7(15:8)

    SCT0_Init();                                           // Initialize SCT0

    while (1)                                              // loop forever
    {
        if (!(LPC_GPIO->PIN[2] & (1 << 5)) && trg)         // P2.5 (S2) high to low?
        {
            trg = 0;                                       // trigger P2.5 low
//            LPC_SCT0->RELFRAMATCH[1].U  = 8;               // use dithering (8 out of 16 cycles)
            LPC_SCT0->RELFRAMATCH[1].U  = 15;               // use dithering (8 out of 16 cycles)
        }
        else if ((LPC_GPIO->PIN[2] & (1 << 5)) && !trg)    // P2.5 low to high?
        {
            LPC_SCT0->RELFRAMATCH[1].U  = 0;               // dithering off
            trg = 1;                                       // trigger P2.5 high
        }
    }
}
